<?php
    /**
    *
    * copyright (c) 2013-2018 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/articolo.php?id=34&alias=linee-guida-per-l%27uso-del-logo-geecom
    */         

    /**
     * Classe statica che contiene metodi di ausilio a varie parti estetiche del sito
     *
     * @author andrea
     */
    class UtilTemplate {
        
        static function stampaRoot($configurazioneAspetto) {
            echo"<link rel=\"shortcut icon\" href=\"{$configurazioneAspetto["favicon"]}\" />
                <link href=\"{$configurazioneAspetto["linkFont"]}\" rel=\"stylesheet\" type=\"text/css\">
                <style type=\"text/css\">
                :root {
                --input-padding-x: .75rem;
                --input-padding-y: .75rem;
                --primary: {$configurazioneAspetto["colorePrimario"]};
                --primary-over: {$configurazioneAspetto["colorePrimarioHover"]};
                --primary-active: {$configurazioneAspetto["colorePrimarioActive"]};
                --secondary: {$configurazioneAspetto["coloreSecondario"]};
                --secondary-over: {$configurazioneAspetto["coloreSecondarioHover"]};
                --secondary-active: {$configurazioneAspetto["coloreSecondarioActive"]};
                --success: {$configurazioneAspetto["coloreSuccess"]};
                --success-over: {$configurazioneAspetto["coloreSuccessHover"]};
                --success-active: {$configurazioneAspetto["coloreSuccessHover"]};
                --info: {$configurazioneAspetto["coloreInfo"]};
                --info-over: {$configurazioneAspetto["coloreInfoHover"]};
                --info-active: {$configurazioneAspetto["coloreInfoActive"]};
                --warning: {$configurazioneAspetto["coloreWarning"]};
                --warning-over: {$configurazioneAspetto["coloreWarningHover"]};
                --warning-active: {$configurazioneAspetto["coloreWarningActive"]};
                --danger: {$configurazioneAspetto["coloreDanger"]};
                --danger-over: {$configurazioneAspetto["coloreDangerHover"]};
                --danger-active: {$configurazioneAspetto["coloreDangerActive"]};
                --light: {$configurazioneAspetto["coloreLight"]};
                --light-over: {$configurazioneAspetto["coloreLightHover"]};
                --light-active: {$configurazioneAspetto["coloreLightActive"]};
                --dark: {$configurazioneAspetto["coloreDark"]};
                --dark-over: {$configurazioneAspetto["coloreDarkHover"]};
                --dark-active: {$configurazioneAspetto["coloreDarkActive"]};
                --breakpoint-xs: 0;
                --breakpoint-sm: {$configurazioneAspetto["breakingPointsXs"]};
                --breakpoint-md: {$configurazioneAspetto["breakingPointsMd"]};
                --breakpoint-lg: {$configurazioneAspetto["breakingPointsLg"]};
                --breakpoint-xl: {$configurazioneAspetto["breakingPointsXl"]};
            }
            body{ 
                {$configurazioneAspetto["fontTesti"]}
            }
            h1, h2, h3, h4, h5, h6, 
            .h1, .h2, .h3, .h4, .h5, .h6 { 
                {$configurazioneAspetto["fontIntestazioni"]}
            }
            </style>";            
        }
        
        static function stampaComponenti($geecomDb,$gestoreJavascript,$impostazioni,$impostazioniRicerca,$configurazioneAspetto,$idContenuto, $tipoElemento = "contenuto", $stampaSezione = "si") {
            $queryComponentiDaMostrare = "SELECT c.nome,posizione,tipo,testo,ch.script,idElemento,idSezione,classeSezione,animazione,altreOpzioni,aTuttaLarghezza,coloreSfondo,immagineSfondo,videoSfondo FROM geecD_composizionePagine AS ch "
                            . "JOIN geecD_componenti AS c ON ch.idComponente =c.id "
                            . "WHERE idPagina={$idContenuto} AND ch.tipoElemento='$tipoElemento' "
                            . "ORDER BY posizione ASC";
            $risComponentiHome = $geecomDb->eseguiQueryLettura($queryComponentiDaMostrare);
            
            while($componente = $risComponentiHome->fetch_assoc()) {
                UtilTemplate::stampaSingoloComponente($geecomDb,$gestoreJavascript,$impostazioni,$impostazioniRicerca,$configurazioneAspetto,$componente,$stampaSezione);
            }
        }

        static function stampaSingoloComponente($geecomDb,$gestoreJavascript,$impostazioni,$impostazioniRicerca,$configurazioneAspetto,$componente,$stampaSezione="si") {
            if($componente["nome"]=="Intestazione") {
                stampaIntestazione($componente);
            }
            else if($componente["nome"]=="Testo") {
                stampaTesto($componente);
            }
            else if($componente["nome"]=="Html") {
                stampaCodiceHtml($componente);
            }
            else if($componente["nome"]=="Immagine") {
                stampaImmagine($impostazioni,$componente);
            }
            else if($componente["nome"]=="Includi codice") {
                includiCodice($componente);
            }
            else if($componente["nome"]=="Risorse") {
                $visualizzatoreComponente = new VisualizzatoreRisorse($geecomDb);
                $visualizzatoreComponente->generaContenutoSezione($componente);
                $gestoreJavascript->aggiungiJavascript($visualizzatoreComponente->getJavascriptAssociato());
            }
            else if($componente["nome"]=="Risorse private") {
                $visualizzatoreComponente = new VisualizzatoreRisorsePrivate($geecomDb);
                $visualizzatoreComponente->generaContenutoSezione($componente);
                $gestoreJavascript->aggiungiJavascript($visualizzatoreComponente->getJavascriptAssociato());
            }
            else if($componente["nome"]=="Form") {
                $visualizzatoreComponente = new VisualizzatoreForm($geecomDb);
                $visualizzatoreComponente->creaSezione($componente);
            }
            else if($componente["nome"]=="Audio") {
                stampaAudio($componente);
            }
            else if($componente["nome"]=="Approvazione file") {
                $visualizzatoreComponente = new VisualizzatoreApprovazioneFile($geecomDb);
                $visualizzatoreComponente->creaSezione($componente);
            }
            else if($componente["nome"]=="Condivisione file") {
                $visualizzatoreComponente = new VisualizzatoreCondivisioneFile($geecomDb);
                $visualizzatoreComponente->creaSezione($componente,"full-height d-flex align-items-center");
            }
        }
        
        static function stampaScrollTop() {
            echo"<button onclick=\"topFunction()\" id=\"toTop\" title=\"Inizio\" class=\"\"><i class=\"fas fa-chevron-up\"></i></button>";
        }
        
        static function stampaFooter($geecomDb,$impostazioniFooter) {
            $classeColonna = UtilTemplate::calcolaClasseColonne($impostazioniFooter["numeroColonne"]);
            for($i=1 ;$i<=$impostazioniFooter["numeroColonne"]; $i++) {
                UtilTemplate::stampaColonnaFooter($geecomDb,$impostazioniFooter,$i,$classeColonna);
            }
        }
        
        static function stampaColonnaFooter($geecomDb,$impostazioniFooter,$numeroColonna,$classeColonna) {
            echo"<div class=\"$classeColonna {$impostazioniFooter["coloreTestiMenu"]}\">
                <h4>{$impostazioniFooter["titoloColonna$numeroColonna"]}</h4>
                    <ul class=\"list-group {$impostazioniFooter["coloreTestiMenu"]}\">";
                    $queryMenu = "SELECT * FROM geecD_vociMenu WHERE idMenu={$impostazioniFooter["colonna$numeroColonna"]} AND tipo NOT LIKE 'voce sottoMenu' ORDER BY posizione ASC";
                    $risVociMenu = $geecomDb->eseguiQueryLettura($queryMenu);

                    while($voceMenu = $risVociMenu->fetch_assoc()) {
                        $stringaIcona = ($voceMenu["icona"]!="") ? "<i class=\"{$voceMenu["icona"]}\"></i> " : "";
                        if($voceMenu["tipo"]=="link immagine") {
                            echo"<li ><a href=\"{$voceMenu["link"]}\"><img src=\"{$voceMenu["immagine"]}\"></a></li>";
                        }
                        else {
                            echo"<li ><a href=\"{$voceMenu["link"]}\">$stringaIcona {$voceMenu["nome"]}</a></li>";
                        }
                    }
                echo"</ul>
            </div>";
        }
        
        static function calcolaClasseColonne($numeroColonna) {
            if($numeroColonna==1) {
                return "col-12 mb-2";
            }
            elseif($numeroColonna==2) {
                return "col-sm-6 mb-4 mb-sm-2";
            }
            elseif($numeroColonna==3) {
                return "col-md-4 mb-4 mb-md-2";
            }
            elseif($numeroColonna==4) {
                return "col-sm-6 col-md-3 mb-4 mb-sm-2 mb-md-2";
            }
            else {
                return "";
            }
        }
    }